/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.block;

import me.ultrusmods.missingwilds.tags.MissingWildsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PolyporeMushroomBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty AMOUNT = IntegerProperty.m_61631_((String)"amount", (int)1, (int)2);
    private static final VoxelShape SOUTH_ONE = Block.m_49796_((double)2.0, (double)9.0, (double)0.0, (double)14.0, (double)12.0, (double)6.0);
    private static final VoxelShape SOUTH_TWO = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)12.0, (double)7.0);
    private static final VoxelShape EAST_ONE = Block.m_49796_((double)0.0, (double)9.0, (double)2.0, (double)6.0, (double)12.0, (double)14.0);
    private static final VoxelShape EAST_TWO = Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)7.0, (double)12.0, (double)16.0);
    private static final VoxelShape NORTH_ONE = Block.m_49796_((double)2.0, (double)9.0, (double)10.0, (double)14.0, (double)12.0, (double)16.0);
    private static final VoxelShape NORTH_TWO = Block.m_49796_((double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape WEST_ONE = Block.m_49796_((double)10.0, (double)9.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0);
    private static final VoxelShape WEST_TWO = Block.m_49796_((double)9.0, (double)7.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public PolyporeMushroomBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case SOUTH: {
                return (Integer)state.m_61143_((Property)AMOUNT) == 1 ? SOUTH_ONE : SOUTH_TWO;
            }
            case NORTH: {
                return (Integer)state.m_61143_((Property)AMOUNT) == 1 ? NORTH_ONE : NORTH_TWO;
            }
            case EAST: {
                return (Integer)state.m_61143_((Property)AMOUNT) == 1 ? EAST_ONE : EAST_TWO;
            }
            case WEST: {
                return (Integer)state.m_61143_((Property)AMOUNT) == 1 ? WEST_ONE : WEST_TWO;
            }
        }
        return super.m_5940_(state, world, pos, context);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(50) == 0 && (Integer)state.m_61143_((Property)AMOUNT) == 1) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AMOUNT, (Comparable)Integer.valueOf(2)), 2);
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = ctx.m_43725_().m_8055_(ctx.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)blockState.m_61122_((Property)AMOUNT);
        }
        for (Direction direction : ctx.m_6232_()) {
            if (!direction.m_122434_().m_122479_()) continue;
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction.m_122424_());
        }
        return super.m_5573_(ctx);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_41720_() == this.m_5456_() && (Integer)state.m_61143_((Property)AMOUNT) < 2 || super.m_6864_(state, context);
    }

    private boolean isValidBlock(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_204336_(BlockTags.f_13106_) || blockState.m_204336_(MissingWildsTags.FALLEN_LOGS);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos placedOnPos = pos.m_121945_(direction.m_122424_());
        BlockState placedOnState = world.m_8055_(placedOnPos);
        return placedOnState.m_60783_((BlockGetter)world, pos, direction) && this.isValidBlock((BlockGetter)world, pos.m_121945_(direction.m_122424_()));
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor world, BlockPos blockPos, BlockPos blockPos1) {
        return direction.m_122424_() == blockState.m_61143_((Property)FACING) && !blockState.m_60710_((LevelReader)world, blockPos) ? Blocks.f_50016_.m_49966_() : blockState;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, AMOUNT});
    }
}

